/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.client.rmc;

import com.ibm.hsc.client.rmc.HSCRMCException;
import com.ibm.hsc.client.rmc.PIHSCRMCClient;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.util.LparCmdRMSessionMgr;
import com.ibm.rsct.rmcjni.McClassActionRsp;
import com.ibm.rsct.util.CtDataType;
import com.ibm.rsct.util.CtInt32;
import com.ibm.rsct.util.CtString;
import com.ibm.rsct.util.CtStructuredData;
import com.ibm.rsct.util.CuException;
import com.ibm.websm.diagnostics.IDebug;
import java.io.Serializable;
import java.util.Hashtable;

public class PIHSCRMCClientImpl
implements PIHSCRMCClient {
    private static final String DLPAR_BUNDLE_NAME = "HSCCIMExceptionBundle";
    private static final String LPAR_BUNDLE_NAME = "LPARBundle";
    private static final String ERR_DRMGR_CMD_FAILED = "drmgr command failed";
    private static final String ERR_LOCAL_RMC_SYS = "Error in local RMC subsystem";
    protected static final String RMC_RETURN_CODE = "Rc";
    protected static final String RMC_CMD_RETURN_CODE = "CmdRc";
    protected static final String RMC_CMD_STD_OUT = "CmdStdoutMsg";
    protected static final String RMC_CMD_STD_ERR = "CmdStderrMsg";
    protected static final String RMC_CMD_SUCC_NUM = "CmdSuccNum";
    protected static final String RMC_CMD_POPT_SUCC_NUM = "CmdPOptSuccNum";
    protected static final String RMC_DLPAR_COMMAND = "DLParCommand";
    protected static final String RMC_REMOTE_COMMAND = "RemoteCommand";
    protected static final int CMD_SHUTDOWN_ID = 1;
    protected static final int RMC_ERROR = 2;
    protected static final int AIX_ERROR = 4;
    protected static final String ERROR_CODE = "HMC_ERROR_CODE";
    private static final String ERR_RMC_CMD_EXCEPTION = "HMCERRV3DLPAR003: RMC operation {0} on {1} resource throws exception. The request number is {2}. The success number is {3}";
    private static final String ERR_RMC_CMD_EXCEPTION_2 = "{0} operation for {1} resource failed.";
    private static final String ERR_RMC_CMD_ERROR_NO_OUT = "HMCERRV3DLPAR004: RMC operation {0} on {1} resource failed without throwing exception. The request number is {2}. The success number is {3}. The AIX standard output/error is not available.";
    private static final String ERR_RMC_CMD_ERROR_NO_OUT_2 = "RMC operation {0} on {1} resource failed without throwing exception. The RPA partition standard output/error is not available.";
    private static final String ERR_RMC_CMD_ERROR = "HMCERRV3DLPAR005: RMC operation {0} on {1} resource failed without throwing exception. The request number is {2}. The success number is {3}. The AIX standard output is:\n {4}\nThe AIX standard error is:\n{5}";
    private static final String ERR_RMC_AIX_CMD_ERROR = "HMCERRV3DLPAR020: AIX DLPAR operation {0} on {1} resource failed without throwing exception. The request number is {2}. The success number is {3}.\nThe AIX command is:\n{4}\n\nThe AIX standard output is:\n {5}\nThe AIX standard error is:\n{6}";
    private static final String RMC_AIX_RETURN_CODE = "The RMC return code is {0}. The AIX return code is {1}.";
    private String mCECName;
    private String mLPARName;

    public static PIHSCRMCClientImpl createInstance(String string, String string2) throws HSCException {
        return new PIHSCRMCClientImpl(string, string2);
    }

    protected PIHSCRMCClientImpl(String string, String string2) {
        this.mCECName = string;
        this.mLPARName = string2;
    }

    protected HSCRMCException createException(String string, String string2, int n, int n2, Hashtable hashtable, int n3, String string3) {
        Object object;
        String string4 = null;
        if (hashtable == null) {
            string4 = HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "ERR_RMC_CMD_ERROR_NO_OUT", ERR_RMC_CMD_ERROR_NO_OUT, new String[]{string, string2, "" + n2, "" + n});
        } else {
            String string5;
            if (string2.equals("mem") && (object = (Integer)hashtable.get(RMC_CMD_SUCC_NUM)) != null) {
                n = (Integer)object;
            }
            if ((object = (String)hashtable.get(RMC_CMD_STD_OUT)) == null || ((String)object).equals("")) {
                object = " ";
            }
            if ((string5 = (String)hashtable.get(RMC_CMD_STD_ERR)) == null || string5.equals("")) {
                string5 = " ";
            }
            string4 = (n3 & 2) != 0 ? HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "ERR_RMC_CMD_ERROR", ERR_RMC_CMD_ERROR, new String[]{string, string2, "" + n2, "" + n, object, string5}) : HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "ERR_RMC_AIX_CMD_ERROR", ERR_RMC_AIX_CMD_ERROR, new String[]{string, string2, "" + n2, "" + n, string3, object, string5});
            string4 = string4 + "\n" + hashtable.get(ERROR_CODE);
            hashtable.remove(ERROR_CODE);
        }
        if (IDebug.enabled) {
            System.out.println("command failed without exception");
        }
        object = new HSCRMCException(string4, n);
        ((HSCRMCException)object).setAIXError(n3 == 4);
        if (IDebug.enabled) {
            System.out.println("newExp: " + object);
        }
        return object;
    }

    protected HSCRMCException createCPUException(String string, String string2, int n, long l, Hashtable hashtable, int n2, String string3) {
        Serializable serializable;
        String string4 = null;
        boolean bl = false;
        boolean bl2 = false;
        if (hashtable == null) {
            string4 = HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "ERR_RMC_CMD_ERROR_NO_OUT_2", ERR_RMC_CMD_ERROR_NO_OUT_2, new String[]{string, string2});
        } else {
            String string5;
            String string6;
            serializable = (Integer)hashtable.get(RMC_CMD_SUCC_NUM);
            if (serializable != null) {
                int n3 = (Integer)serializable;
                n += n3;
            }
            if ((string6 = (String)hashtable.get(RMC_CMD_STD_OUT)) == null || string6.equals("")) {
                string6 = " ";
            }
            if ((string5 = (String)hashtable.get(RMC_CMD_STD_ERR)) == null || string5.equals("")) {
                string5 = " ";
            }
            string4 = (n2 & 2) != 0 ? HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "ERR_RMC_CMD_ERROR", ERR_RMC_CMD_ERROR, new String[]{string, string2, "" + l, "" + n, string6, string5}) : HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "ERR_RMC_AIX_CMD_ERROR", ERR_RMC_AIX_CMD_ERROR, new String[]{string, string2, "" + l, "" + n, string3, string6, string5});
            string4 = string4 + "\n" + hashtable.get(ERROR_CODE);
            hashtable.remove(ERROR_CODE);
        }
        if (IDebug.enabled) {
            System.out.println("command failed without exception");
        }
        serializable = new HSCRMCException(string4, n);
        ((HSCRMCException)serializable).setAIXError(n2 == 4);
        if (IDebug.enabled) {
            System.out.println("newExp: " + serializable);
        }
        return serializable;
    }

    public int rmcDLPAROp(int n, int n2, short s, String string, String[] stringArray, String string2) throws HSCRMCException {
        String string3 = n2 < 1 ? null : "" + n2;
        Object var8_8 = null;
        int n3 = 0;
        if (string.equals("mem")) {
            this.runRMCCommand(n, string3, string, s, string2, null, n3);
        } else {
            for (int i = 0; i < n; ++i) {
                String string4 = stringArray == null ? null : stringArray[i];
                this.runRMCCommand(n, string3, string, s, string2, string4, n3);
                ++n3;
            }
        }
        return n;
    }

    public int rmcDLPARCpuOp(int n, long l, int n2, int n3, short s, String string) throws HSCRMCException {
        String string2 = n3 < 1 ? null : "" + n3;
        Object var9_8 = null;
        int n4 = 0;
        this.runRMCCpuCommand(n, l, n2, string2, s, string, n4);
        return n;
    }

    public void rmcDLPARPHBOp(String string, int n, short s, String string2) throws HSCRMCException {
        String string3 = n < 1 ? null : "" + n;
        this.runRMCPHBCommand(string, string3, s, string2);
    }

    public Hashtable rmcShutdownOp(boolean bl, boolean bl2) throws HSCException {
        CtStructuredData ctStructuredData = new CtStructuredData(new CtDataType[5]);
        Hashtable<String, Object> hashtable = null;
        String string = this.getRMCShutdownCommand(bl, bl2);
        if (IDebug.enabled) {
            System.out.println("HSCRMCClient.rmcShutdownOp() - command arguments = " + string);
        }
        try {
            ctStructuredData.setData(0, (CtDataType)new CtString(this.mCECName.substring(0, this.mCECName.indexOf(42))));
            ctStructuredData.setData(1, (CtDataType)new CtString(this.mCECName.substring(this.mCECName.indexOf(42) + 1)));
            ctStructuredData.setData(2, (CtDataType)new CtString(this.mLPARName.substring(0, this.mLPARName.indexOf(42))));
            ctStructuredData.setData(3, (CtDataType)new CtInt32(1));
            ctStructuredData.setData(4, (CtDataType)new CtString(string));
            McClassActionRsp[] mcClassActionRspArray = LparCmdRMSessionMgr.getLparCmdRMSession().invokeAction(RMC_REMOTE_COMMAND, null, ctStructuredData);
            if (mcClassActionRspArray != null) {
                CtStructuredData[] ctStructuredDataArray = mcClassActionRspArray[0].getData();
                if (ctStructuredDataArray != null) {
                    CtStructuredData ctStructuredData2 = ctStructuredDataArray[0];
                    if (IDebug.enabled) {
                        if (ctStructuredData2 != null) {
                            System.out.println("HSCRMCClient.rmcShutdownOp() - outParams element count = " + ctStructuredData2.getElementCount());
                        } else {
                            System.out.println("HSCRMCClient.rmcShutdownOp() - outParams is null");
                        }
                    }
                    if (ctStructuredData2 != null && ctStructuredData2.getElementCount() > 1) {
                        hashtable = new Hashtable<String, Object>();
                        hashtable.put(RMC_RETURN_CODE, new Integer(((CtInt32)ctStructuredData2.getData(0)).getData()));
                        hashtable.put(RMC_CMD_RETURN_CODE, new Integer(((CtInt32)ctStructuredData2.getData(1)).getData()));
                        hashtable.put("CmdRetMsg", ((CtString)ctStructuredData2.getData(2)).getData());
                    }
                } else if (mcClassActionRspArray[0].hasError()) {
                    throw new CuException(mcClassActionRspArray[0].getErrorMessage());
                }
            }
        }
        catch (Exception exception) {
            if (IDebug.enabled) {
                exception.printStackTrace(System.out);
            }
            LparCmdRMSessionMgr.invalidateLparCmdRMSession();
            throw new HSCException(exception);
        }
        return hashtable;
    }

    private void runRMCCommand(int n, String string, String string2, short s, String string3, String string4, int n2) throws HSCRMCException {
        Hashtable hashtable = null;
        String string5 = this.getRMCCommand(string, string4, string3, string2, s, n);
        try {
            hashtable = this.rmcDLPARCommand(string5, s);
        }
        catch (Throwable throwable) {
            throw new HSCRMCException(HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "ERR_RMC_CMD_EXCEPTION", ERR_RMC_CMD_EXCEPTION, new String[]{string3, string2, "" + n, "" + n2}), throwable, n2);
        }
        int n3 = this.prtDLPARCmdOut(hashtable);
        if (IDebug.enabled) {
            System.out.println("rtn: " + n3);
        }
        if (n3 == 0) {
            if (string2.equals("mem")) {
                Integer n4 = (Integer)hashtable.get(RMC_CMD_SUCC_NUM);
                n2 = n4 == null ? 0 : n4;
                if (n2 == n) {
                    return;
                }
            } else {
                return;
            }
        }
        throw this.createException(string3, string2, n2, n, hashtable, n3, string5);
    }

    private void runRMCCpuCommand(int n, long l, int n2, String string, short s, String string2, int n3) throws HSCRMCException {
        Hashtable hashtable = null;
        String string3 = "cpu";
        String string4 = "ent_capacity";
        String string5 = "variable_weight";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        long l2 = 0L;
        String string6 = "";
        if (n > 0) {
            string6 = new String(" -q " + n);
            bl = true;
        } else if (l > 0L) {
            string6 = new String(" -q " + l + " -p " + string4);
            bl2 = true;
        } else if (n2 >= 0) {
            string6 = new String(" -q " + n2 + " -p " + string5);
            bl3 = true;
        }
        String string7 = "drmgr -c cpu -" + string2 + string6 + (string == null ? "" : " -w " + string) + (s < 0 ? "" : " -d " + s);
        System.out.println("in runRMCCpuCommand - cmd = " + string7);
        try {
            hashtable = this.rmcDLPARCommand(string7, s);
        }
        catch (Throwable throwable) {
            throw new HSCRMCException(HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "ERR_RMC_CMD_EXCEPTION_2", ERR_RMC_CMD_EXCEPTION_2, new String[]{string2, "cpu"}), throwable, n3);
        }
        int n4 = this.prtDLPARCmdOut(hashtable);
        if (IDebug.enabled) {
            System.out.println("rtn: " + n4);
        }
        if (n4 == 0) {
            return;
        }
        if (bl) {
            l2 = n;
        } else if (bl2) {
            l2 = l;
        } else if (bl3) {
            l2 = n2;
        }
        throw this.createCPUException(string2, string3, n3, l2, hashtable, n4, string7);
    }

    private void runRMCPHBCommand(String string, String string2, short s, String string3) throws HSCRMCException {
        Hashtable hashtable = null;
        String string4 = "drmgr -" + string3 + " -c " + "phb" + " -s " + "\"" + string + "\"" + (string2 == null ? "" : " -w " + string2) + (s < 0 ? "" : " -d " + s);
        System.out.println("in runRMCPHBCommand - cmd = " + string4);
        int n = 1;
        int n2 = 0;
        try {
            hashtable = this.rmcDLPARCommand(string4, s);
        }
        catch (Throwable throwable) {
            throw new HSCRMCException(HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "ERR_RMC_CMD_EXCEPTION", ERR_RMC_CMD_EXCEPTION, new String[]{string3, "phb", "" + n, "" + n2}), throwable, n2);
        }
        int n3 = this.prtDLPARCmdOut(hashtable);
        if (IDebug.enabled) {
            System.out.println("rtn: " + n3);
        }
        if (n3 == 0) {
            return;
        }
        throw this.createException(string3, "phb", n2, n, hashtable, n3, string4);
    }

    public Hashtable runRMCConcMaintCommand(int n, String string, String string2, short s, String string3, String string4, int n2) throws HSCException {
        Hashtable hashtable = null;
        String string5 = this.getRMCCommand(string, string4, string3, string2, s, n);
        try {
            hashtable = this.rmcDLPARCommand(string5, s);
        }
        catch (Throwable throwable) {
            throw new HSCRMCException(HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "ERR_RMC_CMD_EXCEPTION", ERR_RMC_CMD_EXCEPTION, new String[]{string3, string2, "" + n, "" + n2}), throwable, n2);
        }
        int n3 = this.prtDLPARCmdOut(hashtable);
        hashtable.put("ErrType", new Integer(n3));
        if (n3 != 0) {
            HSCRMCException hSCRMCException = this.createException(string3, string2, n2, n, hashtable, n3, string5);
            hashtable.put("Exception", hSCRMCException);
        }
        return hashtable;
    }

    private Hashtable rmcDLPARCommand(String string, short n) throws HSCException {
        int n2 = 0;
        CtStructuredData ctStructuredData = new CtStructuredData(new CtDataType[5]);
        Hashtable<String, Object> hashtable = null;
        if (IDebug.enabled) {
            System.out.println("rmc command: " + string);
        }
        if (n != -1 && n <= 5) {
            n2 = n;
        }
        if (n == 99) {
            n2 = 99;
        }
        try {
            ctStructuredData.setData(0, (CtDataType)new CtString(this.mCECName.substring(0, this.mCECName.indexOf(42))));
            ctStructuredData.setData(1, (CtDataType)new CtString(this.mCECName.substring(this.mCECName.indexOf(42) + 1)));
            String string2 = new String(this.mLPARName.substring(0, this.mLPARName.indexOf(42)));
            System.out.println("LPAR NAME is " + string2);
            ctStructuredData.setData(2, (CtDataType)new CtString(string2));
            ctStructuredData.setData(3, (CtDataType)new CtString(string));
            ctStructuredData.setData(4, (CtDataType)new CtInt32(n2));
            McClassActionRsp[] mcClassActionRspArray = LparCmdRMSessionMgr.getLparCmdRMSession().invokeAction(RMC_DLPAR_COMMAND, null, ctStructuredData);
            if (mcClassActionRspArray != null) {
                CtStructuredData[] ctStructuredDataArray = mcClassActionRspArray[0].getData();
                if (ctStructuredDataArray != null) {
                    CtStructuredData ctStructuredData2 = ctStructuredDataArray[0];
                    if (IDebug.enabled) {
                        if (ctStructuredData2 != null) {
                            System.out.println("return elm count: " + ctStructuredData2.getElementCount());
                        } else {
                            System.out.println("outParams is null");
                        }
                    }
                    if (ctStructuredData2 != null && ctStructuredData2.getElementCount() > 1) {
                        hashtable = new Hashtable<String, Object>();
                        hashtable.put(RMC_RETURN_CODE, new Integer(((CtInt32)ctStructuredData2.getData(0)).getData()));
                        hashtable.put(RMC_CMD_RETURN_CODE, new Integer(((CtInt32)ctStructuredData2.getData(1)).getData()));
                        if (ctStructuredData2.getElementCount() > 2) {
                            hashtable.put(RMC_CMD_STD_OUT, ((CtString)ctStructuredData2.getData(2)).getData());
                        }
                        if (ctStructuredData2.getElementCount() > 3) {
                            hashtable.put(RMC_CMD_STD_ERR, ((CtString)ctStructuredData2.getData(3)).getData());
                        }
                        if (ctStructuredData2.getElementCount() > 4) {
                            hashtable.put(RMC_CMD_SUCC_NUM, new Integer(((CtInt32)ctStructuredData2.getData(4)).getData()));
                            if (IDebug.enabled) {
                                System.out.println("succ_num is: " + (Integer)hashtable.get(RMC_CMD_SUCC_NUM));
                            }
                        }
                    }
                } else if (mcClassActionRspArray[0].hasError()) {
                    throw new CuException(mcClassActionRspArray[0].getErrorMessage());
                }
            }
        }
        catch (Exception exception) {
            if (IDebug.enabled) {
                exception.printStackTrace(System.out);
            }
            LparCmdRMSessionMgr.invalidateLparCmdRMSession();
            throw new HSCException(exception);
        }
        return hashtable;
    }

    private int prtDLPARCmdOut(Hashtable hashtable) {
        int n = 0;
        if (hashtable == null) {
            if (IDebug.enabled) {
                System.out.println(HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "DLPAR_COMMAND_FAILED", ERR_LOCAL_RMC_SYS));
            }
            ++n;
        } else {
            Object v;
            if (IDebug.enabled) {
                System.out.println(hashtable.get(RMC_CMD_STD_OUT));
                System.out.println(hashtable.get(RMC_CMD_STD_ERR));
            }
            System.out.println(hashtable.get(RMC_CMD_STD_OUT));
            System.out.println(hashtable.get(RMC_CMD_STD_ERR));
            Object v2 = hashtable.get(RMC_RETURN_CODE);
            if (v2 == null || (Integer)v2 != 0) {
                if (IDebug.enabled) {
                    System.out.println(HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "DLPAR_COMMAND_FAILED", ERR_LOCAL_RMC_SYS));
                    System.out.println("RMC_RETURN_CODE: " + (Integer)v2);
                }
                System.out.println("RMC_RETURN_CODE: " + (Integer)v2);
                n += 2;
            }
            if ((v = hashtable.get(RMC_CMD_RETURN_CODE)) == null || (Integer)v != 0) {
                if (IDebug.enabled) {
                    System.out.println(HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "DRMGR_FAILED", ERR_DRMGR_CMD_FAILED));
                    System.out.println("RMC_CMD_RETURN_CODE: " + (Integer)v);
                }
                System.out.println(HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "DRMGR_FAILED", ERR_DRMGR_CMD_FAILED));
                System.out.println("RMC_CMD_RETURN_CODE: " + (Integer)v);
                n += 4;
            }
            String string = HSCResourceBundleUtil.getMessage(DLPAR_BUNDLE_NAME, "RMC_AIX_RETURN_CODE", RMC_AIX_RETURN_CODE, new String[]{"" + v2, "" + v});
            hashtable.put(ERROR_CODE, string);
        }
        return n;
    }

    private String getRMCCommand(String string, String string2, String string3, String string4, short s, int n) {
        return "drmgr -" + string3 + " -c " + string4 + (string2 == null ? "" : " -s " + string2) + (string4.equals("mem") || string4.equals("cpu") ? " -q " + n : "") + (string == null ? "" : " -w " + string) + (s < 0 ? "" : " -d " + s);
    }

    private String getRMCShutdownCommand(boolean bl, boolean bl2) {
        return " " + (bl2 ? "-F " : "") + (bl ? "-r " : "");
    }

    public Hashtable rmcIOServerCmd(String string, String string2) throws HSCException {
        Hashtable<String, Object> hashtable = null;
        CtStructuredData ctStructuredData = null;
        if (IDebug.enabled) {
            System.out.println("LparMTMS=" + string);
            System.out.println("IOCmd=" + string2);
        }
        String string3 = string.substring(0, string.indexOf(42));
        String string4 = string.substring(string.indexOf(42) + 1);
        String string5 = string4.substring(0, string4.indexOf(42));
        String string6 = string4.substring(string4.indexOf(42) + 1);
        if (IDebug.enabled) {
            System.out.println("MT=" + string5 + " MS=" + string6);
            System.out.println("LparID=" + string3);
        }
        try {
            ctStructuredData = new CtStructuredData(new CtDataType[6]);
            ctStructuredData.setData(0, (CtDataType)new CtString(string5));
            ctStructuredData.setData(1, (CtDataType)new CtString(string6));
            ctStructuredData.setData(2, (CtDataType)new CtString(string3));
            ctStructuredData.setData(3, (CtDataType)new CtString(string2));
            ctStructuredData.setData(4, (CtDataType)new CtInt32(0));
            ctStructuredData.setData(5, (CtDataType)new CtString("C"));
            McClassActionRsp[] mcClassActionRspArray = LparCmdRMSessionMgr.getLparCmdRMSession().invokeAction(RMC_DLPAR_COMMAND, null, ctStructuredData);
            if (mcClassActionRspArray != null) {
                CtStructuredData[] ctStructuredDataArray = mcClassActionRspArray[0].getData();
                if (ctStructuredDataArray != null) {
                    CtStructuredData ctStructuredData2 = ctStructuredDataArray[0];
                    if (IDebug.enabled) {
                        if (ctStructuredData2 != null) {
                            System.out.println("return elm count: " + ctStructuredData2.getElementCount());
                        } else {
                            System.out.println("outParams is null");
                        }
                    }
                    Integer n = null;
                    Integer n2 = null;
                    Integer n3 = new Integer(-1);
                    String string7 = "";
                    String string8 = "";
                    if (ctStructuredData2 != null && ctStructuredData2.getElementCount() > 1) {
                        n = new Integer(((CtInt32)ctStructuredData2.getData(0)).getData());
                        n2 = new Integer(((CtInt32)ctStructuredData2.getData(1)).getData());
                        if (ctStructuredData2.getElementCount() > 2) {
                            string7 = ((CtString)ctStructuredData2.getData(2)).getData();
                        }
                        if (ctStructuredData2.getElementCount() > 3) {
                            string8 = ((CtString)ctStructuredData2.getData(3)).getData();
                        }
                        if (ctStructuredData2.getElementCount() > 4) {
                            n3 = new Integer(((CtInt32)ctStructuredData2.getData(4)).getData());
                        }
                        if (IDebug.enabled) {
                            System.out.println("Result from LparCmdRM");
                            System.out.println("rmcRc   =" + n);
                            System.out.println("cmdRc   =" + n2);
                            System.out.println("succNum =" + n3);
                            System.out.println("stdOut  =" + string7);
                            System.out.println("stdErr  =" + string8);
                        }
                        hashtable = new Hashtable<String, Object>();
                        if (string7 != null) {
                            hashtable.put("CmdRetMsg", string7);
                        }
                        if (string8 != null) {
                            hashtable.put("CmdErrMsg", string8);
                        }
                        if (n2 != null) {
                            hashtable.put(RMC_CMD_RETURN_CODE, n2);
                        }
                        if (n != null) {
                            hashtable.put(RMC_RETURN_CODE, n);
                        }
                    }
                } else if (mcClassActionRspArray[0].hasError()) {
                    throw new CuException(mcClassActionRspArray[0].getErrorMessage());
                }
            }
        }
        catch (Exception exception) {
            if (IDebug.enabled) {
                exception.printStackTrace(System.out);
            }
            LparCmdRMSessionMgr.invalidateLparCmdRMSession();
            throw new HSCException(exception);
        }
        return hashtable;
    }

    public void runRMCSendCoDAsyncMsg(String string) throws HSCException {
        String string2 = string;
        int n = 0;
        CtStructuredData ctStructuredData = new CtStructuredData(new CtDataType[5]);
        Object var5_5 = null;
        int n2 = 0;
        if (IDebug.enabled) {
            System.out.println("rmc command: " + string2);
        }
        if (n2 != -1 && n2 <= 5) {
            n = n2;
        }
        if (n2 == 99) {
            n = 99;
        }
        try {
            ctStructuredData.setData(0, (CtDataType)new CtString(this.mCECName.substring(0, this.mCECName.indexOf(42))));
            ctStructuredData.setData(1, (CtDataType)new CtString(this.mCECName.substring(this.mCECName.indexOf(42) + 1)));
            String string3 = new String(this.mLPARName.substring(0, this.mLPARName.indexOf(42)));
            System.out.println("LPAR NAME is " + string3);
            ctStructuredData.setData(2, (CtDataType)new CtString(string3));
            ctStructuredData.setData(3, (CtDataType)new CtString(string2));
            ctStructuredData.setData(4, (CtDataType)new CtInt32(n));
            System.out.println("In PIHSCRMCClientImpl::runRMCSendCoDAsyncMsg method ... about to send this command to AIX: " + string2);
            McClassActionRsp[] mcClassActionRspArray = LparCmdRMSessionMgr.getLparCmdRMSession().invokeAction(RMC_DLPAR_COMMAND, null, ctStructuredData);
            System.out.println("In PIHSCRMCClientImpl::runRMCSendCoDAsyncMsg method ... back from sending command to AIX: " + string2);
            if (mcClassActionRspArray != null) {
                CtStructuredData[] ctStructuredDataArray = mcClassActionRspArray[0].getData();
                if (ctStructuredDataArray != null) {
                    CtStructuredData ctStructuredData2 = ctStructuredDataArray[0];
                    if (IDebug.enabled) {
                        if (ctStructuredData2 != null) {
                            System.out.println("return elm count: " + ctStructuredData2.getElementCount());
                        } else {
                            System.out.println("outParams is null");
                        }
                    }
                    Integer n3 = new Integer(-1);
                    String string4 = "";
                    String string5 = "";
                    if (ctStructuredData2 != null && ctStructuredData2.getElementCount() > 1) {
                        Integer n4 = new Integer(((CtInt32)ctStructuredData2.getData(0)).getData());
                        Integer n5 = new Integer(((CtInt32)ctStructuredData2.getData(1)).getData());
                        if (ctStructuredData2.getElementCount() > 2) {
                            string4 = ((CtString)ctStructuredData2.getData(2)).getData();
                        }
                        if (ctStructuredData2.getElementCount() > 3) {
                            string5 = ((CtString)ctStructuredData2.getData(3)).getData();
                        }
                        if (ctStructuredData2.getElementCount() > 4) {
                            n3 = new Integer(((CtInt32)ctStructuredData2.getData(4)).getData());
                        }
                        if (IDebug.enabled) {
                            System.out.println("Result from LparCmdRM");
                            System.out.println("rmcRc   =" + n4);
                            System.out.println("cmdRc   =" + n5);
                            System.out.println("succNum =" + n3);
                            System.out.println("stdOut  =" + string4);
                            System.out.println("stdErr  =" + string5);
                        }
                        if (n4 != 0 || n5 != 0) {
                            String string6 = "RmcRC=" + n4 + " CmdRc=" + n5;
                            if (string4 != null && string4.length() > 0) {
                                string6 = string4;
                            } else if (string5 != null && string5.length() > 0) {
                                string6 = string5;
                            }
                            throw new HSCException(string6);
                        }
                    }
                } else if (mcClassActionRspArray[0].hasError()) {
                    throw new CuException(mcClassActionRspArray[0].getErrorMessage());
                }
            }
        }
        catch (Throwable throwable) {
            throw new HSCException("Failed to send CoD Async msg to RPA partition");
        }
    }
}

